/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.command;

import com.ibm.hsc.client.PIHSCCECClient;
import com.ibm.hsc.client.PIHSCClientObjectFactory;
import com.ibm.hsc.client.PIHSCLPARClient;
import com.ibm.hsc.command.PIHMCCommandUtils;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.exceptions.PIHscClientException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;

public class PIVirtualIOServerCommand {
    private static final int NUM_VALID_PARMS = 3;
    private String m_command;
    private String m_managedSystem;
    private String m_partitionId;
    private String m_partitionName;
    private String mtms;
    private HashMap m_validParms = new HashMap(7, 0.5f);
    private PIHSCClientObjectFactory m_factory = null;
    private PIHSCCECClient m_cecClient = null;
    private PIHSCLPARClient m_lparClient = null;
    private PrintStream m_out;
    private boolean m_writeStatus;

    private PIVirtualIOServerCommand(PIHSCCECClient pIHSCCECClient, PrintStream printStream, boolean bl) {
        this.m_cecClient = pIHSCCECClient;
        this.m_out = printStream;
        this.m_writeStatus = bl;
        this.m_validParms.put("-c", null);
        this.m_validParms.put("-m", null);
        this.m_validParms.put("--id", null);
        this.m_validParms.put("-p", null);
        this.mtms = this.m_cecClient.getIntName();
    }

    private void performCommand() throws PIHscClientException {
        String string = null;
        String[] stringArray = null;
        Vector vector = new Vector();
        this.checkParameters();
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_factory = PIHSCClientObjectFactory.getInstance(string, null);
        this.m_lparClient = this.m_partitionId != null ? this.m_factory.createLPARClient(this.m_managedSystem, this.m_partitionId, true) : this.m_factory.createLPARClient(this.m_managedSystem, this.m_partitionName, false);
        if (this.m_lparClient == null) {
            if (this.m_partitionName != null) {
                stringArray = new String[]{this.m_partitionName};
                throw new PIHscClientException("8000", "HSCExceptionBundle", "8012", stringArray, null);
            }
            stringArray = new String[]{this.m_partitionId.substring(0, this.m_partitionId.indexOf(42))};
            throw new PIHscClientException("8000", "HSCExceptionBundle", "8011", stringArray, null);
        }
        String string2 = this.m_lparClient.runVirtualServerCommand(this.m_command);
        if (this.m_writeStatus) {
            this.m_writeStatus = false;
            this.m_out.print('\u0000');
        }
        this.m_out.print(string2);
    }

    private void checkParameters() throws PIHscClientException {
        String string = "";
        if (null == this.m_managedSystem || this.m_managedSystem.length() == 0) {
            string = string + "-m";
        }
        if (null == this.m_command || this.m_command.length() == 0) {
            if (string.length() != 0) {
                string = string + ", ";
            }
            string = string + "-c";
        }
        if (this.m_partitionName != null && this.m_partitionId != null) {
            if (string.length() > 0) {
                string = string + ", ";
            }
            string = string + "-p " + HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "OR") + " " + "--id";
        }
        if (string.length() > 0) {
            String[] stringArray = new String[]{string};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", stringArray, null);
        }
    }

    private void mapParameters(HashMap hashMap) {
        this.m_command = (String)hashMap.get("-c");
        this.m_managedSystem = (String)hashMap.get("-m");
        this.m_partitionId = (String)hashMap.get("--id");
        this.m_partitionName = (String)hashMap.get("-p");
    }

    public static void printHelp(PrintStream printStream, boolean bl) {
        if (bl) {
            printStream.print('\u0000');
        }
        printStream.println(HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "VIOSVRCMD_HELP"));
    }

    public static int callCommandFromRouter(PIHSCCECClient pIHSCCECClient, String[] stringArray, PrintStream printStream, boolean bl) {
        int n = 0;
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        PIVirtualIOServerCommand pIVirtualIOServerCommand = new PIVirtualIOServerCommand(pIHSCCECClient, printStream, bl);
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
            HashMap hashMap = PIHMCCommandUtils.parseParameters(arrayList, pIVirtualIOServerCommand.m_validParms);
            pIVirtualIOServerCommand.mapParameters(hashMap);
            pIVirtualIOServerCommand.performCommand();
        }
        catch (PIHscClientException pIHscClientException) {
            if (bl) {
                bl = false;
                printStream.print('\u0001');
            }
            pIHscClientException.printStackTrace(System.out);
            if ("8000".equals(pIHscClientException.getHscExId())) {
                printStream.println(pIHscClientException.getMessage());
            } else {
                String string = pIHscClientException.getMessage();
                if (string == null || string.length() == 0) {
                    string = HSCResourceBundleUtil.getMessage("HSCExceptionBundle", "8016");
                }
                printStream.println(string);
            }
            n = 1;
        }
        catch (Exception exception) {
            if (bl) {
                bl = false;
                printStream.print('\u0001');
            }
            exception.printStackTrace(System.out);
            String string = HSCResourceBundleUtil.getMessage("HSCExceptionBundle", "COMMAND_LINE_ERROR");
            printStream.println(string);
            n = 1;
        }
        return n;
    }
}

